(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     10955,        395]*)
(*NotebookOutlinePosition[     11857,        425]*)
(*  CellTagsIndexPosition[     11813,        421]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData["Quick Series Solution"], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "This notebook finds the first ",
  StyleBox["n",
    FontWeight->"Bold"],
  " terms of the power series solution of the first order differential \
equation ",
  StyleBox["L[x, y] = 0",
    FontWeight->"Bold"],
  ". The notebook just finds the terms; it does not state the recursion \
relation, though that recursion relation may be read from one of the outputs \
in the solution process. Of course, once you have a guess of a recursion \
relation, you can set out to verify and solve it. The ",
  StyleBox["Comments",
    FontSlant->"Italic"],
  "  suggest that the method can be extended."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["Define the operator"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[{\(Clear[x, y]\), "\n", 
    RowBox[{\(L[x_, y_]\), "=", 
      RowBox[{
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}], 
        "-", \(2\ x\ y[x]\)}]}]}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{\(\(-2\)\ x\ y[x]\), "+", 
      RowBox[{
        SuperscriptBox["y", "\[Prime]",
          MultilineFunction->None], "[", "x", "]"}]}]], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Set n (the number of terms desired)"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(n = 10\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(10\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The series to be assumed"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"The next cell says to create a sum of n terms and effectively turn it into a \
series by saying that the terms beyond n are indefinite. (O[x]^(n+1) \
indicates we know nothing about terms of order n+1 and beyond.)"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(y[x_] = \[Sum]\+\(i = 0\)\%n a[i]\ x\^i + O[x]\^\(n + 1\)\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\(a[0]\), "+", \(a[1]\ x\), "+", \(a[2]\ x\^2\), 
        "+", \(a[3]\ x\^3\), "+", \(a[4]\ x\^4\), "+", \(a[5]\ x\^5\), 
        "+", \(a[6]\ x\^6\), "+", \(a[7]\ x\^7\), "+", \(a[8]\ x\^8\), 
        "+", \(a[9]\ x\^9\), "+", \(a[10]\ x\^10\), "+", 
        InterpretationBox[\(O[x]\^11\),
          SeriesData[ x, 0, {}, 0, 11, 1]]}],
      SeriesData[ x, 0, {
        a[ 0], 
        a[ 1], 
        a[ 2], 
        a[ 3], 
        a[ 4], 
        a[ 5], 
        a[ 6], 
        a[ 7], 
        a[ 8], 
        a[ 9], 
        a[ 10]}, 0, 11, 1]]], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Substitute"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(LHS = Collect[L[x, y], x] + O[x]\^\(n + 1\)\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\(a[1]\), "+", \(\((\(-2\)\ a[0] + 2\ a[2])\)\ x\), 
        "+", \(\((\(-2\)\ a[1] + 3\ a[3])\)\ x\^2\), 
        "+", \(\((\(-2\)\ a[2] + 4\ a[4])\)\ x\^3\), 
        "+", \(\((\(-2\)\ a[3] + 5\ a[5])\)\ x\^4\), 
        "+", \(\((\(-2\)\ a[4] + 6\ a[6])\)\ x\^5\), 
        "+", \(\((\(-2\)\ a[5] + 7\ a[7])\)\ x\^6\), 
        "+", \(\((\(-2\)\ a[6] + 8\ a[8])\)\ x\^7\), 
        "+", \(\((\(-2\)\ a[7] + 9\ a[9])\)\ x\^8\), 
        "+", \(\((\(-2\)\ a[8] + 10\ a[10])\)\ x\^9\), "+", 
        InterpretationBox[\(O[x]\^11\),
          SeriesData[ x, 0, {}, 0, 11, 1]]}],
      SeriesData[ x, 0, {
        a[ 1], 
        Plus[ 
          Times[ -2, 
            a[ 0]], 
          Times[ 2, 
            a[ 2]]], 
        Plus[ 
          Times[ -2, 
            a[ 1]], 
          Times[ 3, 
            a[ 3]]], 
        Plus[ 
          Times[ -2, 
            a[ 2]], 
          Times[ 4, 
            a[ 4]]], 
        Plus[ 
          Times[ -2, 
            a[ 3]], 
          Times[ 5, 
            a[ 5]]], 
        Plus[ 
          Times[ -2, 
            a[ 4]], 
          Times[ 6, 
            a[ 6]]], 
        Plus[ 
          Times[ -2, 
            a[ 5]], 
          Times[ 7, 
            a[ 7]]], 
        Plus[ 
          Times[ -2, 
            a[ 6]], 
          Times[ 8, 
            a[ 8]]], 
        Plus[ 
          Times[ -2, 
            a[ 7]], 
          Times[ 9, 
            a[ 9]]], 
        Plus[ 
          Times[ -2, 
            a[ 8]], 
          Times[ 10, 
            a[ 10]]]}, 0, 11, 1]]], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Equate the coefficients to 0"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(sys = LogicalExpand[LHS == 0]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(a[1] == 0 && \(-2\)\ a[0] + 2\ a[2] == 0 && \(-2\)\ a[1] + 3\ a[3] == 
        0 && \(-2\)\ a[2] + 4\ a[4] == 0 && \(-2\)\ a[3] + 5\ a[5] == 
        0 && \(-2\)\ a[4] + 6\ a[6] == 0 && \(-2\)\ a[5] + 7\ a[7] == 
        0 && \(-2\)\ a[6] + 8\ a[8] == 0 && \(-2\)\ a[7] + 9\ a[9] == 
        0 && \(-2\)\ a[8] + 10\ a[10] == 0\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Find the Coefficients"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "Using ",
  StyleBox["Reverse[Table[a[i],{i,0,n}]] ",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "makes the form of the coefficients agree with what you would find by hand: \
the latter terms are found in terms of the former."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(coeff = Solve[sys, Reverse[Table[a[i], {i, 0, n}]]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(Solve::"svars" \(\(:\)\(\ \)\) 
      "Equations may not give solutions for all \"solve\" variables."\)], \
"Message"],

Cell[BoxData[
    \({{a[10] \[Rule] a[0]\/120, a[9] \[Rule] 0, a[8] \[Rule] a[0]\/24, 
        a[7] \[Rule] 0, a[6] \[Rule] a[0]\/6, a[5] \[Rule] 0, 
        a[4] \[Rule] a[0]\/2, a[3] \[Rule] 0, a[2] \[Rule] a[0], 
        a[1] \[Rule] 0}}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Get the solution series; take a[0]==1."], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(s[x_] = \(y[x] /. coeff\[LeftDoubleBracket]1\[RightDoubleBracket]\) /. 
        a[0] \[Rule] 1\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "1", "+", \(x\^2\), "+", \(x\^4\/2\), "+", \(x\^6\/6\), 
        "+", \(x\^8\/24\), "+", \(x\^10\/120\), "+", 
        InterpretationBox[\(O[x]\^11\),
          SeriesData[ x, 0, {}, 0, 11, 1]]}],
      SeriesData[ x, 0, {1, 0, 1, 0, 
        Rational[ 1, 2], 0, 
        Rational[ 1, 6], 0, 
        Rational[ 1, 24], 0, 
        Rational[ 1, 120]}, 0, 11, 1]]], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["A Series of Exp[x^2]"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(soln[x_] = Series[Exp[x\^2], {x, 0, n}]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "1", "+", \(x\^2\), "+", \(x\^4\/2\), "+", \(x\^6\/6\), 
        "+", \(x\^8\/24\), "+", \(x\^10\/120\), "+", 
        InterpretationBox[\(O[x]\^11\),
          SeriesData[ x, 0, {}, 0, 11, 1]]}],
      SeriesData[ x, 0, {1, 0, 1, 0, 
        Rational[ 1, 2], 0, 
        Rational[ 1, 6], 0, 
        Rational[ 1, 24], 0, 
        Rational[ 1, 120]}, 0, 11, 1]]], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Check"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[L[x, s]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    InterpretationBox[\(O[x]\^10\),
      SeriesData[ x, 0, {}, 10, 10, 1]]], "Output"]
}, Closed]],

Cell[TextData[
"This says that L[x,s] = 0 through terms of order 9 in x."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Comments"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "This technique will also work for many second order equations. The \
solution will have two undetermined coefficients, which serve as the \
arbitrary constants. There are problems in which this simple-minded technique \
does not work. In these, the leading coefficient is zero when x = 0. For such \
problems the point x = 0 is called ",
  StyleBox["singular",
    FontVariations->{"Underline"->True}],
  ". We will encounter these later and propose a method of solution for the \
simplest of the singular problems (the ",
  StyleBox["regular",
    FontVariations->{"Underline"->True}],
  " singular problems)."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{551, 588},
WindowMargins->{{67, Automatic}, {Automatic, 8}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 100, 2, 65, "Subtitle",
  Evaluatable->False],
Cell[1879, 57, 670, 17, 104, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2574, 78, 97, 2, 56, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2696, 84, 271, 7, 43, "Input"],
Cell[2970, 93, 173, 4, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[3192, 103, 113, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3330, 109, 66, 2, 27, "Input"],
Cell[3399, 113, 36, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[3484, 120, 102, 2, 36, "Section",
  Evaluatable->False],
Cell[3589, 124, 289, 5, 68, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3903, 133, 117, 2, 49, "Input"],
Cell[4023, 137, 614, 19, 47, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[4686, 162, 88, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[4799, 168, 103, 2, 29, "Input"],
Cell[4905, 172, 1604, 59, 83, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[6558, 237, 106, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6689, 243, 89, 2, 27, "Input"],
Cell[6781, 247, 360, 5, 75, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[7190, 258, 99, 2, 36, "Section",
  Evaluatable->False],
Cell[7292, 262, 316, 9, 50, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[7633, 275, 111, 2, 27, "Input"],
Cell[7747, 279, 138, 3, 35, "Message"],
Cell[7888, 284, 254, 4, 76, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[8191, 294, 116, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8332, 300, 154, 3, 27, "Input"],
Cell[8489, 305, 431, 11, 45, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[8969, 322, 98, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[9092, 328, 99, 2, 31, "Input"],
Cell[9194, 332, 431, 11, 45, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[9674, 349, 83, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[9782, 355, 77, 2, 27, "Input"],
Cell[9862, 359, 101, 2, 29, "Output"]
}, Closed]],
Cell[9978, 364, 132, 3, 32, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[10147, 372, 86, 2, 36, "Section",
  Evaluatable->False],
Cell[10236, 376, 691, 15, 104, "Text",
  Evaluatable->False]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

8530, 252, 111, 2, 70, "Input"],
Cell[8644, 256, 303, 6, 70, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[8988, 264, 116, 2, 70, "Section"],

Cell[CellGroupData[{
Cell[9127, 268, 161, 4, 70, "Input"],
Cell[9291, 274, 604, 17, 70, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[9936, 293, 98, 2, 70, "Section"],

Cell[CellGroupData[{
Cell[10057, 297, 99, 2, 70, "Input"],
Cell[10159, 301, 604, 17, 70, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[10804, 320, 83, 2, 70, "Section"],

Cell[CellGroupData[{
Cell[10910, 324, 77, 2, 70, "Input"],
Cell[10990, 328, 172, 4, 70, "Output"]
}, Closed]],
Cell[11174, 334, 132, 3, 70, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[11338, 339, 86, 2, 70, "Section"],
Cell[11427, 343, 691, 15, 70, "Text"]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)
